<?php

namespace App\Http\Middleware;

use App\Language;
use Closure;

class LanguageApi
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if (isset($_SERVER['HTTP_LANG'])) {
            $locale = $_SERVER['HTTP_LANG'];
        } else {
            $locale = defaultLanguage();
        }
        app()->setLocale($locale);
        return $next($request);
    }
}
