<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CheckExpireSubscribtion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $currentTenant = app('currentTenant');
        if (Session::get('tenant_end_subscribtion_data')['subscribtionEnded'] == true) {
            return redirect()->route('Package.renew', encrypt($currentTenant->subscribtion_id));
        }
        return $next($request);
    }
}
