<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\App;

use Closure;
use Illuminate\Support\Facades\Session;

class AdminLanguage
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Session::has('locale')) {
            app()->setLocale(Session::get('locale'));
        } else {
            app()->setLocale(defaultLanguage());
        }
        return $next($request);
    }
}
