<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class AdminAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $user = Auth::user();
        if (!$user->hasAdminAccess) {
            return redirect('/');
        } else {
            return $next($request);
        }
    }

    public function terminate($request, $response)
    {
        return $request->all();
    }
}
